/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.action.handlers;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.execution.ActionExecutionException;
import com.floragunn.signals.execution.SimulationMode;
import com.floragunn.signals.execution.WatchExecutionContext;
import com.floragunn.signals.execution.WatchExecutionException;
import com.floragunn.signals.watch.action.handlers.ActionExecutionResult;
import com.floragunn.signals.watch.action.handlers.ActionHandler;
import com.floragunn.signals.watch.common.HttpClient;
import com.floragunn.signals.watch.common.HttpClientConfig;
import com.floragunn.signals.watch.common.HttpRequestConfig;
import com.floragunn.signals.watch.common.HttpUtils;
import com.floragunn.signals.watch.common.WatchElement;
import com.floragunn.signals.watch.init.WatchInitializationService;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class WebhookAction
extends ActionHandler {
    private static final Logger log = LogManager.getLogger(WebhookAction.class);
    public static final String TYPE = "webhook";
    private final HttpRequestConfig requestConfig;
    private final HttpClientConfig httpClientConfig;

    public WebhookAction(HttpRequestConfig request, HttpClientConfig httpClientConfig) {
        this.requestConfig = request;
        this.httpClientConfig = httpClientConfig;
    }

    @Override
    public ActionExecutionResult execute(WatchExecutionContext ctx) throws ActionExecutionException {
        ActionExecutionResult actionExecutionResult;
        block11: {
            HttpClient httpClient = this.httpClientConfig.createHttpClient(ctx.getHttpProxyConfig());
            try {
                CloseableHttpResponse response;
                HttpUriRequest request = this.requestConfig.createHttpRequest(ctx);
                if (log.isDebugEnabled()) {
                    log.debug("Going to execute: " + request);
                }
                if (ctx.getSimulationMode() == SimulationMode.FOR_REAL && (response = AccessController.doPrivileged(() -> httpClient.execute(request))).getStatusLine().getStatusCode() >= 400) {
                    throw new WatchExecutionException("Web hook returned error: " + response.getStatusLine() + "\n\n" + HttpUtils.getEntityAsDebugString((HttpResponse)response), null);
                }
                actionExecutionResult = new ActionExecutionResult(HttpUtils.getRequestAsDebugString(request));
                if (httpClient == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PrivilegedActionException e) {
                    throw new ActionExecutionException((ActionHandler)this, e.getCause());
                }
                catch (Exception e) {
                    throw new ActionExecutionException((ActionHandler)this, (Throwable)e);
                }
            }
            httpClient.close();
        }
        return actionExecutionResult;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public Iterable<? extends WatchElement> getChildren() {
        return Iterables.concat(super.getChildren(), Collections.singletonList(this.requestConfig));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("request");
        this.requestConfig.toXContent(builder, params);
        this.httpClientConfig.toXContent(builder, params);
        return builder;
    }

    public static class Factory
    extends ActionHandler.Factory<WebhookAction> {
        public Factory() {
            super(WebhookAction.TYPE);
        }

        @Override
        protected WebhookAction create(WatchInitializationService watchInitService, ValidatingDocNode vJsonNode, ValidationErrors validationErrors) throws ConfigValidationException {
            HttpClientConfig httpClientConfig = null;
            HttpRequestConfig request = null;
            if (vJsonNode.hasNonNull("request")) {
                try {
                    request = HttpRequestConfig.create(watchInitService, vJsonNode.getDocumentNode().getAsNode("request"));
                }
                catch (ConfigValidationException e) {
                    validationErrors.add("request", e);
                }
            } else {
                validationErrors.add((ValidationError)new MissingAttribute("request", (Object)vJsonNode));
            }
            try {
                httpClientConfig = HttpClientConfig.create(vJsonNode);
            }
            catch (ConfigValidationException e) {
                validationErrors.add(null, e);
            }
            validationErrors.throwExceptionForPresentErrors();
            return new WebhookAction(request, httpClientConfig);
        }
    }
}

